/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.site.service.impl;

import com.tp_link.eap.device.EventType;
import com.tp_link.eap.domain.account.User;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.Location;
import com.tp_link.eap.domain.eap.bean.Radio;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.AccessSubnetGroup;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.hotspot.Operator;
import com.tp_link.eap.domain.message.ForgetType;
import com.tp_link.eap.domain.meta.Data;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.c.k;
import com.tp_link.eap.monitor.cloud.clouduser.repo.CloudUserRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SubnetRepository;
import com.tp_link.eap.monitor.globalsetting.repo.WlanGroupRepository;
import com.tp_link.eap.monitor.globalsetting.repo.impl.BandSteeringRepository;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.m;
import com.tp_link.eap.monitor.globalsetting.service.n;
import com.tp_link.eap.monitor.hotspot.repo.OperatorRepository;
import com.tp_link.eap.monitor.hotspot.service.OperatorServiceI;
import com.tp_link.eap.monitor.monitor.cache.CacheTask;
import com.tp_link.eap.monitor.monitor.service.b;
import com.tp_link.eap.monitor.monitor.service.c;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.h;
import com.tp_link.eap.monitor.monitor.service.j;
import com.tp_link.eap.monitor.record.service.impl.VersionService;
import com.tp_link.eap.monitor.site.service.a;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.site.SiteRepository;
import com.tp_link.eap.user.repo.UserRepository;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.util.a.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="siteService")
public class SiteService
extends com.tp_link.eap.i.a.a<Site>
implements a {
    @Autowired
    private SiteRepository a;
    @Autowired
    private PrivilegeServiceI b;
    @Autowired
    private UserRepository c;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.d d;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.e e;
    @Autowired
    private b f;
    @Autowired
    private VersionService g;
    @Autowired
    private n h;
    @Autowired
    private OperatorRepository i;
    @Autowired
    private l j;
    @Autowired
    private d k;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.a l;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.j m;
    @Autowired
    private m n;
    @Autowired
    private com.tp_link.eap.monitor.globalsetting.service.c o;
    @Autowired
    private j p;
    @Autowired
    private c q;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.a r;
    @Autowired
    private com.tp_link.eap.monitor.task.service.a s;
    @Autowired
    private SubnetRepository t;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.b u;
    @Autowired
    private h v;
    @Autowired
    private WlanGroupRepository w;
    @Autowired
    private BandSteeringRepository x;
    @Autowired
    private HttpServletRequest y;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.c z;
    @Autowired
    private OperatorServiceI A;
    @Autowired
    private com.tp_link.eap.monitor.roaming.service.a B;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a C;
    @Autowired
    private CloudUserRepository D;
    private static final Logger E = LoggerFactory.getLogger(SiteService.class);
    private ExecutorService F = Executors.newFixedThreadPool(com.tp_link.eap.c.a.b);

    @Override
    public List<Site> getSites() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"})));
    }

    @Override
    public List<Site> getUserSites(String userName) {
        if (null == userName) {
            return null;
        }
        List list = this.b.getUserPrivileges(userName);
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (Privilege privilege : list) {
            arrayList.add(this.a.findBySiteName(privilege.getSiteName()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addSite(Site addSite) {
        if (this.a.count() >= 100L) {
            E.debug("site size {} has reached maximum", (Object)this.a.count());
            return new OperationResponse(ResErrorCode.bE);
        }
        if (addSite == null || com.tp_link.eap.util.a.e.a((String)addSite.getName()) || addSite.getName().length() > 32) {
            E.warn("site or site name is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Site site = null;
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            OperationResult operationResult;
            String string;
            Site site2 = this.a.findByName(addSite.getName());
            if (site2 != null) {
                E.warn("Site {} to create is already existed.", (Object)addSite.getName());
                return new OperationResponse(ResErrorCode.p);
            }
            if (!addSite.isSystemDefault()) {
                string = com.tp_link.eap.util.k.a.a();
                while (this.siteNameAlreadyExist(string)) {
                    string = com.tp_link.eap.util.k.a.a();
                }
                addSite.setSiteName(string);
            } else {
                string = this.a.findBySystemDefault(true);
                if (string != null) {
                    E.warn("DefaultSite already exist.");
                    return new OperationResponse(ResErrorCode.q);
                }
                addSite.setName("Default");
                addSite.setSiteName("Default");
            }
            site = (Site)this.a.save((Object)addSite);
            if (site == null) {
                E.warn("DB operation Failed.");
                return new OperationResponse(ResErrorCode.i);
            }
            this.b.assignSiteToAdministrators(site.getSiteName());
            string = this.C.getOwner();
            if (string != null) {
                this.b.assignSiteToUser(string.getAccountIdEncrypted(), site.getSiteName(), string.getRole());
            }
            if (!site.isSystemDefault() && !(operationResult = this.a(site.getSiteName())).equals(com.tp_link.eap.util.e.bc)) {
                E.warn("Failed to initSiteBasicConfig");
                return new OperationResponse(ResErrorCode.b);
            }
        }
        object = new JSONObject();
        object.put((Object)"siteName", (Object)site.getSiteName());
        return new OperationResponse(ResErrorCode.a, object);
    }

    @Override
    public OperationResponse modifySite(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("name");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            E.warn("Invalid request, missing name");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!com.tp_link.eap.util.p.c.a((String)string, (int)1, (int)32)) {
            E.warn("Invalid site name, Site name must be 1-32 characters.");
            return new OperationResponse(ResErrorCode.o);
        }
        String string2 = jSONObject.optString("siteName");
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            E.warn("Site {} to edit is not exist.", (Object)string2);
            return new OperationResponse(ResErrorCode.r);
        }
        return this.a(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(String string, String string2) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Site site = this.a.findBySiteName(string);
            if (site == null) {
                E.warn("Site {} to edit is not exist.", (Object)string);
                return new OperationResponse(ResErrorCode.r);
            }
            Site site2 = this.a.findByName(string2);
            if (site2 != null && site2.getSiteName() != null && !site2.getSiteName().equals(string)) {
                E.warn("Site name {} is already existed.", (Object)string2);
                return new OperationResponse(ResErrorCode.p);
            }
            site.setName(string2);
            this.a.save((Object)site);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse switchSite(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("siteName");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            E.warn("Invalid request, missing site");
            return com.tp_link.eap.util.e.aZ;
        }
        if (controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) {
            String string2 = jSONObject.optString("userName");
            if (com.tp_link.eap.util.a.e.a((String)string2)) {
                E.warn("Invalid request, missing name");
                return com.tp_link.eap.util.e.aZ;
            }
            OperationResponse operationResponse = this.switchSite(string2, string);
            if (operationResponse.success()) {
                String string3 = this.y.getSession().getId();
                com.tp_link.eap.d.b.a((String)string3, (String)string);
                com.tp_link.eap.monitor.hotspot.security.a.a(string3, true);
            }
            return operationResponse;
        }
        String string4 = reqObj.optString("cloudUserSessionId");
        if (com.tp_link.eap.util.a.e.a((String)string4)) {
            E.warn("Failed to find sessionId in getCurrentCloudUserInfo");
            return com.tp_link.eap.util.e.aY;
        }
        String string5 = com.tp_link.eap.monitor.cloud.clouduser.a.a.a(string4);
        if (com.tp_link.eap.util.a.e.a((String)string5)) {
            E.warn("Failed to find accountId for session {}", (Object)string4);
            return com.tp_link.eap.util.e.aY;
        }
        CloudUser cloudUser = this.C.getCloudUserByAccountId(string5);
        if (cloudUser == null) {
            E.warn("Cloud user {} not exists.", (Object)com.tp_link.eap.monitor.cloud.e.a.c(string5));
            return new OperationResponse(ResErrorCode.ct);
        }
        return this.a(string4, cloudUser, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse switchSite(String userName, String newSiteKey) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            String string = com.tp_link.eap.d.b.a();
            if (string == null) {
                E.error("fail to get old site info while switch site.");
                return new OperationResponse(ResErrorCode.b);
            }
            User user = this.c.findByName(userName);
            if (user == null) {
                E.warn("User name {} not exists.", (Object)userName);
                return new OperationResponse(ResErrorCode.ct);
            }
            Site site = this.a.findBySiteName(newSiteKey);
            if (site == null) {
                E.warn("Site {} not exists.", (Object)newSiteKey);
                return new OperationResponse(ResErrorCode.r);
            }
            user.setLastSite(newSiteKey);
            this.c.save((Object)user);
            com.tp_link.eap.d.b.a((String)this.y.getSession().getId(), (String)newSiteKey);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"siteName", (Object)site.getSiteName());
            return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
        }
    }

    @Override
    public OperationResponse switchSiteHs(String operName, String newSite) {
        String string = com.tp_link.eap.d.b.a();
        if (string == null) {
            E.debug("fail to get old site info while switch site.");
            return new OperationResponse(ResErrorCode.d);
        }
        Operator operator = this.i.findByName(operName);
        if (operator == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (this.b.getUserSitePrivilege(operName, newSite) == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        operator.setLastSite(newSite);
        this.i.save(operator);
        com.tp_link.eap.d.b.a((String)this.y.getSession().getId(), (String)newSite);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("siteName", newSite);
        return new OperationResponse(ResErrorCode.a, null, hashMap);
    }

    @Override
    public OperationResponse deleteSite(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("siteName");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            E.warn("Invalid request, missing site");
            return com.tp_link.eap.util.e.aZ;
        }
        if (controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) {
            String string2 = jSONObject.optString("userName");
            if (com.tp_link.eap.util.a.e.a((String)string2)) {
                E.warn("Invalid request, missing name");
                return com.tp_link.eap.util.e.aZ;
            }
            return this.b(string2, string);
        }
        String string3 = reqObj.optString("cloudUserSessionId");
        if (com.tp_link.eap.util.a.e.a((String)string3)) {
            E.warn("Failed to find sessionId in getCurrentCloudUserInfo");
            return com.tp_link.eap.util.e.aY;
        }
        String string4 = com.tp_link.eap.monitor.cloud.clouduser.a.a.a(string3);
        if (com.tp_link.eap.util.a.e.a((String)string4)) {
            E.warn("Failed to find accountId for session {}", (Object)string3);
            return com.tp_link.eap.util.e.aY;
        }
        return this.a(string3, string4, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse b(String string, String string2) {
        if (string == null || string2 == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Object object2 = com.tp_link.eap.b.b.a.l((String)string2);
            synchronized (object2) {
                Site site = this.a.findBySiteName(string2);
                if (site == null) {
                    E.warn("Site to delete is not exist.");
                    com.tp_link.eap.b.b.a.m((String)string2);
                    return new OperationResponse(ResErrorCode.t);
                }
                if (site.isSystemDefault()) {
                    return com.tp_link.eap.util.e.aZ;
                }
                this.a.delete((Object)site);
                com.tp_link.eap.b.b.a.k((String)string2);
                this.b.unassignSitePrivileges(string2);
                String string3 = com.tp_link.eap.d.b.a();
                if (com.tp_link.eap.util.a.e.a((String)string3)) {
                    E.warn("Failed to get currentSite");
                    string3 = this.c.findByName(string).getLastSite();
                }
                if (string2.equals(string3)) {
                    this.switchSite(string, this.a.findBySystemDefault(true).getSiteName());
                }
                this.c(string2);
            }
        }
        this.b(string2);
        com.tp_link.eap.monitor.monitor.upgrade.a.a(string2, null);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResult deleteAllSites() {
        this.a.deleteAll();
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult addSites(List<Site> sites) {
        return null;
    }

    @Override
    public Site getSiteBySiteName(String siteName) {
        return this.a.findBySiteName(siteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse c(String string, String string2) {
        Object object;
        if (string2.equals(com.tp_link.eap.d.b.a())) {
            return com.tp_link.eap.util.e.bd;
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            Ap ap = this.f.getApDetail(string);
            if (ap == null) {
                E.warn("AP {} to move is not exist.", (Object)string);
                return new OperationResponse(ResErrorCode.cS);
            }
            CacheTask.a.a(string);
            com.tp_link.eap.d.b.d((String)string);
            ap.setSite(string2);
            ap.setLocation(new Location(false, false, null, 0.0, 0.0));
            WlanGroup wlanGroup = this.w.findBySiteAndRadioIdAndIsDefault(string2, 0, true);
            E.debug("default wg 2g in new site: {}", (Object)wlanGroup);
            ap.setWlanGroupId2G(wlanGroup.getWlanId());
            ap.setWlan2g(wlanGroup.getName());
            List<Ssid> list = this.j.getSsidsByRadioIdAndWlanId(0, wlanGroup.getWlanId());
            ap.setSsidOverrides(this.a(list));
            wlanGroup = this.w.findBySiteAndRadioIdAndIsDefault(string2, 1, true);
            E.debug("default wg 5g in new site: {}", (Object)wlanGroup);
            ap.setWlanGroupId5G(wlanGroup.getWlanId());
            ap.setWlan5g(wlanGroup.getName());
            list = this.j.getSsidsByRadioIdAndWlanId(1, wlanGroup.getWlanId());
            ap.setSsidOverrides5g(this.a(list));
            com.tp_link.eap.a.b.a((Ap)ap);
            this.a(ap);
            this.f.refreshAp(ap);
            this.B.clearApRoamingInfo(string, true);
        }
        object2 = this.f.getApByMac(string);
        if (object2.getWirelessLinked().booleanValue() && object2.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)object2.getMeshConf().getParentApMac())) {
            this.z.sendDisconnectCommand(object2.getMeshConf().getParentApMac(), string);
        }
        this.z.deleteMeshConf((Ap)object2);
        this.z.removeUplink(object2.getMac());
        this.g.refreshVersion(string);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_FORGET, ForgetType.class, ForgetType.FORGET_NO_RESET, string);
        this.f.deleteApStats(string, com.tp_link.eap.d.b.a());
        if (object2.getWirelessLinked().booleanValue()) {
            this.f.setApStatus(object2.getId(), 0);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse moveSite(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("siteName");
        String string2 = jSONObject.optString("apMac");
        if (com.tp_link.eap.util.a.e.a((String)string2) || com.tp_link.eap.util.a.e.a((String)string)) {
            E.warn("Invalid request, missing name");
            return com.tp_link.eap.util.e.aZ;
        }
        return this.c(string2, string);
    }

    public List<Site> getList(QueryPage queryPage) {
        return this.getList(queryPage, null);
    }

    public List<Site> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<Site> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<Site> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    @Override
    public boolean siteNameAlreadyExist(String siteName) {
        return this.a.findBySiteName(siteName) != null;
    }

    @Override
    public OperationResponse getGridSites(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
            queryData.setSortOrder("asc");
        }
        Grid grid = new Grid(queryData);
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    private OperationResult a(String string) {
        com.tp_link.eap.d.b.b((String)string);
        Data data = com.tp_link.eap.util.g.a.a();
        if (data == null) {
            E.error("Failed to load InitData.json, initSiteBasicConfig failed");
            return com.tp_link.eap.util.e.be;
        }
        this.d.initGlobalEnable(data.getGlobalEnable());
        this.d.initLogSetting(data.getLogSetting());
        this.d.initQosSetting(data.getQosSetting());
        this.d.initWireless(data.getWireless());
        this.d.initBandSteering();
        this.d.initSsh(data.getSshSetting());
        this.d.initManagementVlan(data.getManagementVlanSetting());
        this.d.initMeshSetting();
        this.d.initRoamingSetting();
        String string2 = com.tp_link.eap.util.k.a.a();
        data.getUserAccountSetting().setPassword(string2);
        this.d.initUserAccountSetting(data.getUserAccountSetting());
        WlanGroup wlanGroup = new WlanGroup();
        wlanGroup.setIsDefault(Boolean.valueOf(true));
        wlanGroup.setMaxSsids(Integer.valueOf(8));
        wlanGroup.setName("Default");
        wlanGroup.setRadioId(Integer.valueOf(0));
        this.h.saveWlanGroup(wlanGroup, false);
        wlanGroup.setRadioId(Integer.valueOf(1));
        wlanGroup.setWlanId(null);
        wlanGroup.setId(null);
        this.h.saveWlanGroup(wlanGroup, false);
        AccessSubnetGroup accessSubnetGroup = new AccessSubnetGroup("Default", "block", true);
        accessSubnetGroup.setSite(string);
        this.t.save(accessSubnetGroup);
        return com.tp_link.eap.util.e.bc;
    }

    private void b(String string) {
        List<Ap> list = this.f.getSiteAdoptedAps(string);
        this.F.execute(new com.tp_link.eap.monitor.site.service.impl.a(this, list, string));
    }

    @Override
    public OperationResult deleteConfigBySite(String delSite) {
        com.tp_link.eap.d.b.b((String)delSite);
        this.d.deleteBySite();
        this.b.deleteSitePrivilege(delSite);
        this.h.deleteBySite();
        this.e.deleteBySite();
        this.j.deleteBySite();
        this.l.deleteBySite();
        this.m.deleteBySite();
        this.n.deleteBySite();
        this.o.deleteBySite();
        this.s.deleteBySite();
        this.u.deleteBySite();
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResult deleteStatsBySite(String delSite) {
        com.tp_link.eap.d.b.b((String)delSite);
        this.p.deleteBySite();
        this.k.deleteBySite();
        this.q.deleteBySite();
        this.r.deleteBySite();
        this.v.deleteBySite();
        return com.tp_link.eap.util.e.bc;
    }

    private void c(String string) {
        List list;
        List list2 = this.c.findByLastSite(string);
        if (!CollectionUtils.isEmpty((Collection)list2)) {
            for (Object object : list2) {
                list = this.b.getUserPrivileges(object.getName());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    object.setLastSite(null);
                } else {
                    object.setLastSite(((Privilege)list.get(0)).getSiteName());
                }
                this.c.save(object);
            }
        }
        com.tp_link.eap.monitor.c.k.a(string);
        List<CloudUser> list3 = this.C.findByLastSite(string);
        if (!CollectionUtils.isEmpty((Collection)list3)) {
            Object object;
            object = list3.iterator();
            while (object.hasNext()) {
                list = (CloudUser)object.next();
                List list4 = this.b.getUserPrivileges(list.getAccountIdEncrypted());
                if (CollectionUtils.isEmpty((Collection)list4)) {
                    list.setLastSite(null);
                } else {
                    list.setLastSite(((Privilege)list4.get(0)).getSiteName());
                }
                this.D.save(list);
            }
        }
        com.tp_link.eap.monitor.cloud.clouduser.a.a.g(string);
    }

    private List<SsidOverride> a(List<Ssid> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<SsidOverride> arrayList = new ArrayList<SsidOverride>();
        for (Ssid ssid : list) {
            SsidOverride ssidOverride = new SsidOverride();
            ssidOverride.setIndex(ssid.getIdInt().intValue());
            ssidOverride.setEnable(false);
            ssidOverride.setGlobalSsid(ssid.getName());
            ssidOverride.setRadioId(ssid.getRadioId());
            ssidOverride.setSsid(ssid.getName());
            ssidOverride.setPsk(ssid.getWirelessPasswordPsk());
            ssidOverride.setVlanEnable(false);
            ssidOverride.setVlanId(Integer.valueOf(0));
            arrayList.add(ssidOverride);
        }
        return arrayList;
    }

    private void a(Ap ap) {
        String string = com.tp_link.eap.d.b.a();
        com.tp_link.eap.d.b.b((String)ap.getSite());
        Radio radio = ap.getRadio();
        if (radio != null && radio.getRadioMode().equals("2") && (this.j.isTkipConfigured(0, ap.getWlanGroupId2G()) || this.j.isWepConfigured(0, ap.getWlanGroupId2G()) || this.d.isQoSWmmDisabled(0))) {
            radio.setRadioMode("4");
        }
        if ((radio = ap.getRadio5g()) != null) {
            if (com.tp_link.eap.util.e.b((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
                if ((radio.getRadioMode().equals("8") || radio.getRadioMode().equals("9")) && (this.j.isTkipConfigured(1, ap.getWlanGroupId5G()) || this.j.isWepConfigured(1, ap.getWlanGroupId5G()) || this.d.isQoSWmmDisabled(1))) {
                    radio.setRadioMode("10");
                }
            } else if (radio.getRadioMode().equals("2") && (this.j.isTkipConfigured(1, ap.getWlanGroupId5G()) || this.j.isWepConfigured(1, ap.getWlanGroupId5G()) || this.d.isQoSWmmDisabled(1))) {
                radio.setRadioMode("7");
            }
        }
        com.tp_link.eap.d.b.b((String)string);
    }

    @Override
    public OperationResponse addSite(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("name");
        if (!com.tp_link.eap.util.p.c.a((String)string, (int)1, (int)32)) {
            E.warn("Invalid site name, Site name must be 1-32 characters.");
            return new OperationResponse(ResErrorCode.o);
        }
        Site site = new Site(string, false);
        return this.addSite(site);
    }

    @Override
    public OperationResponse getConfigurableSites(ControlType controlType, JSONObject reqObj) {
        String string;
        Object object;
        Object object2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = null;
        List<Site> list = null;
        if (controlType.equals((Object)ControlType.b) || controlType.equals((Object)ControlType.d)) {
            object2 = reqObj.optString("cloudUserSessionId");
            if (com.tp_link.eap.util.a.e.a((String)object2)) {
                E.warn("Failed to find sessionId in getCurrentCloudUserInfo");
                return com.tp_link.eap.util.e.aY;
            }
            object = com.tp_link.eap.monitor.cloud.clouduser.a.a.a((String)object2);
            if (com.tp_link.eap.util.a.e.a((String)object)) {
                E.warn("Failed to find accountId for session {}", object2);
                return com.tp_link.eap.util.e.aY;
            }
            string2 = jSONObject.optString("userName");
            string = com.tp_link.eap.monitor.cloud.e.a.c((String)object);
            list = this.getUserSites(string);
        } else {
            string2 = jSONObject.optString("userName");
            object2 = (String)SecurityUtils.getSubject().getPrincipal();
            list = this.getUserSites((String)object2);
        }
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty((Collection)(object2 = this.b.getUserPrivileges(string2)))) {
            object = object2.iterator();
            while (object.hasNext()) {
                string = (Privilege)object.next();
                int n2 = this.a((Privilege)string, list);
                if (n2 <= -1) continue;
                list.get(n2).setSelected(true);
            }
        }
        object2 = new HashMap();
        object2.put("data", list);
        return new OperationResponse(ResErrorCode.a, object2);
    }

    @Override
    public OperationResponse switchSiteHs(ControlType controlType, JSONObject reqObj) {
        if (!controlType.equals((Object)ControlType.c) && !controlType.equals((Object)ControlType.a)) {
            E.warn("switchSiteHs only support local control");
            return com.tp_link.eap.util.e.bh;
        }
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            E.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("siteName", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        OperationResponse operationResponse = this.switchSiteHs((String)SecurityUtils.getSubject().getPrincipal(), string);
        if (operationResponse.success()) {
            String string2 = (String)((Map)operationResponse.getResult()).get("siteName");
            com.tp_link.eap.d.b.a((String)this.y.getSession().getId(), (String)string2);
        }
        return operationResponse;
    }

    @Override
    public OperationResponse getCurrentSite(ControlType controlType, JSONObject reqObj) {
        Site site = this.getSiteBySiteName(com.tp_link.eap.d.b.a());
        return new OperationResponse(ResErrorCode.a, (Object)site);
    }

    @Override
    public OperationResponse getOperatorSites(ControlType controlType, JSONObject reqObj) {
        if (!controlType.equals((Object)ControlType.c) && !controlType.equals((Object)ControlType.a)) {
            return new OperationResponse(ResErrorCode.a, "Current user is not operator.", null);
        }
        String string = (String)SecurityUtils.getSubject().getPrincipal();
        List list = this.b.getUserPrivileges(string);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new OperationResponse(ResErrorCode.ej);
        }
        Operator operator = this.A.getOperByName(string);
        if (operator == null) {
            return new OperationResponse(ResErrorCode.a, "Current user is not operator.", null);
        }
        String string2 = com.tp_link.eap.d.b.a();
        if (string2 == null) {
            E.warn("ThreadSite is null, use last site");
            string2 = operator.getLastSite();
        }
        ArrayList<Site> arrayList = new ArrayList<Site>();
        for (Privilege privilege : list) {
            Site site = this.getSiteBySiteName(privilege.getSiteName());
            if (site.getSiteName().equals(string2)) {
                site.setLastVisited(true);
            }
            arrayList.add(site);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)hashMap);
    }

    @Override
    public OperationResponse checkSiteOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.a.count() >= 100L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    private int a(Privilege privilege, List<Site> list) {
        int n2 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getSiteName().equals(privilege.getSiteName())) continue;
            return i2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(String string, CloudUser cloudUser, String string2) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            String string3 = com.tp_link.eap.d.b.a();
            if (string3 == null) {
                E.error("fail to get old site info while switch site.");
                return new OperationResponse(ResErrorCode.b);
            }
            Site site = this.a.findBySiteName(string2);
            if (site == null) {
                E.warn("Site {} not exists.", (Object)string2);
                return new OperationResponse(ResErrorCode.r);
            }
            cloudUser.setLastSite(string2);
            this.C.saveCloudUser(cloudUser);
            com.tp_link.eap.monitor.cloud.clouduser.a.a.b(string, string2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"siteName", (Object)site.getSiteName());
            return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Object object2 = com.tp_link.eap.b.b.a.l((String)string3);
            synchronized (object2) {
                Site site = this.a.findBySiteName(string3);
                if (site == null) {
                    E.warn("Site to delete is not exist.");
                    com.tp_link.eap.b.b.a.m((String)string3);
                    return new OperationResponse(ResErrorCode.t);
                }
                if (site.isSystemDefault()) {
                    return com.tp_link.eap.util.e.aZ;
                }
                this.a.delete((Object)site);
                com.tp_link.eap.b.b.a.k((String)string3);
                this.b.unassignSitePrivileges(string3);
                CloudUser cloudUser = this.C.getCloudUserByAccountId(string2);
                if (cloudUser != null) {
                    String string4 = com.tp_link.eap.d.b.a();
                    if (com.tp_link.eap.util.a.e.a((String)string4)) {
                        E.warn("Failed to get currentSite for deleteSiteByCloudUser");
                        string4 = cloudUser.getLastSite();
                    }
                    if (string3.equals(string4)) {
                        this.a(string, cloudUser, this.a.findBySystemDefault(true).getSiteName());
                    }
                } else {
                    E.error("Failed to find cloudUer for accountIdEncrypted {}", (Object)com.tp_link.eap.monitor.cloud.e.a.c(string2));
                }
                this.c(string3);
            }
        }
        this.b(string3);
        return com.tp_link.eap.util.e.bd;
    }

    static /* synthetic */ b a(SiteService siteService) {
        return siteService.f;
    }
}

